// config: norepeat

#include "GetObjects.js"
#include "GetObject.js"
#include "GetPoint.js"

function DoArrayCurve()
{
	var ui = moi.ui;
	var objectpicker = ui.createObjectPicker();
	
	// Get the objects to array.
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	// Next get the path curve.
	
	ui.beginUIUpdate();
	ui.hideUI( 'SelectObjectsPrompt' );
	ui.showUI( 'SelectPathPrompt' );
	ui.endUIUpdate();
	
	objectpicker.allowCurves();
	
	if ( !GetObject( objectpicker ) )
		return;
		
	var path = objectpicker.objects.item(0);
	
		
	// Now set options. The count and distance edit boxes set an implicit mode when
	// they are changed. The other one will update to a calculated value. We'll set
	// an underline on the label for the current mode.
	
	ui.beginUIUpdate();
	ui.hideUI( 'SelectPathPrompt' );
	ui.showUI( 'OptionsPrompt' );
	ui.showUI( 'ArrayCurveOptions' );
	ui.endUIUpdate();
	
	var factory = moi.command.createFactory( 'arraycurve' );
	factory.setInput( 1, path );
	
	// Get the last used mode, default to number of items.
	
	var mode = 'NumItems';

	try { mode = moi.command.getOption( 'ArrayCurveMode' ); }
	catch(e) { }

	factory.setInput( 2, mode );
	
	var ItemCountStyle = ui.commandUI.ItemCountLabel.style;
	var DistanceStyle = ui.commandUI.DistanceLabel.style;
	
	if ( mode == 'NumItems' )
	{
		// Initialize with number of items mode. Get the last number.
	
		var NumItems = 10;
		
		try	{ NumItems = moi.command.getOption( 'ArrayCurveNumItems' ); }
		catch(e) { }
		
		factory.setInput( 3, NumItems );
		ui.commandUI.NumItems.value = NumItems;
		
		ItemCountStyle.textDecoration = 'underline';
	}
	else
	{
		// Initialize with distance mode. Get the last distance.
		
		var Distance = 1.0;
		
		try { Distance = moi.command.getOption( 'ArrayCurveDistance' ); }
		catch(e) {}
		
		factory.setInput( 4, Distance );
		ui.commandUI.Distance.value = Distance;
		
		DistanceStyle.textDecoration = 'underline';
	}
	
	ui.bindUIToInput( 'RotationStyle', 'value', factory.getInput(5) );
	
	factory.setInput( 0, objects );
	factory.update();

	if ( mode == 'NumItems' )
	{
		// Update distance that was used.
		ui.commandUI.Distance.value = factory.distance;	
	}
	else
	{
		// Update number of items that was generated.
		ui.commandUI.NumItems.value = factory.numItems;
	}
	
	var pointpicker = ui.createPointPicker();
	pointpicker.addSnapFunc( factory, 'snapFunc' );
	pointpicker.onlyUseSnapFunc = true;
	pointpicker.finishOnMouseDown = true;
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'done' )
			break;
			
		if ( pointpicker.event == 'NumItems' )
		{
			// Switch the mode to num items mode.
			factory.setInput( 2, 'NumItems' );

			var NumItems = ui.commandUI.NumItems.value;
			factory.setInput( 3, NumItems );
			
			// Remember this as the last used num items value.
			moi.command.setOption( 'ArrayCurveNumItems', NumItems );
			moi.command.setOption( 'ArrayCurveMode', 'NumItems' );
			
			factory.update();
			
			// Update the distance.
			ui.commandUI.Distance.value = factory.distance;
			
			DistanceStyle.textDecoration = 'none';
			ItemCountStyle.textDecoration = 'underline';
		}
		else if ( pointpicker.event == 'Distance' )
		{
			// Switch the mode to distance mode.
			factory.setInput( 2, 'Distance' );
			
			var Distance = ui.commandUI.Distance.value;
			factory.setInput( 4, Distance );

			// Remember this as the last used distance value.
			moi.command.setOption( 'ArrayCurveDistance', Distance );
			moi.command.setOption( 'ArrayCurveMode', 'Distance' );
			
			factory.update();
			
			// Update the number of items.
			ui.commandUI.NumItems.value = factory.numItems;
			
			ItemCountStyle.textDecoration = 'none';
			DistanceStyle.textDecoration = 'underline';
		}
		else if ( pointpicker.event == 'finished' )
		{
			// Clicked on the base or offset point.
		
			ui.clearPickedPoints();
			pointpicker.clearSnapFuncPoint();
			
			var hitTestResult = factory.hitTestResult;
			
			if ( hitTestResult == 0 || hitTestResult == 1 )
			{
				// Set up another pointpicker for dragging a point on the path curve.
				var picker2 = ui.createPointPicker();
				picker2.restrictToObject( path );
				picker2.finishOnMouseUp = true;
				
				if ( hitTestResult == 1 )
				{
					// Setting the base point for a closed path.
					picker2.bindFunc( factory, 'dragBaseFunc' );
				}
				else
				{
					// Otherwise, setting the offset distance by dragging the offset point.
				
					// Switch the underline to the distance entry.					
					ItemCountStyle.textDecoration = 'none';
					DistanceStyle.textDecoration = 'underline';

					picker2.bindFunc( factory, 'dragOffsetFunc' );
					ui.commandUI.g_Factory = factory;
					picker2.bindFunc( ui.commandUI.UpdateOffsetDrag );
				}
			
				GetPoint( picker2 );
				
				if ( hitTestResult == 0 )
				{
					// Remember the result as the last used distance value.
					moi.command.setOption( 'ArrayCurveDistance', factory.distance );
					moi.command.setOption( 'ArrayCurveMode', 'Distance' );
				}
			}
		
			ui.clearPickedPoints();
		}
		else if ( pointpicker.event == 'AlignToSurface' )
		{
			ui.beginUIUpdate();
			ui.hideUI( 'OptionsPrompt' );
			ui.hideUI( 'ArrayCurveOptions' );
			ui.showUI( 'SelectAlignmentSurfacePrompt' );
			ui.endUIUpdate();
			
			objectpicker.resetAllow();
			objectpicker.allowBreps();
			objectpicker.allowNestedCancel();
	
			if ( GetObject( objectpicker ) )
			{
				var srf = objectpicker.objects.item(0);
				factory.setInput( 7, srf );
				factory.update();
			}
			
			ui.beginUIUpdate();
			ui.showUI( 'OptionsPrompt' );
			ui.showUI( 'ArrayCurveOptions' );
			ui.hideUI( 'SelectAlignmentSurfacePrompt' );
			ui.endUIUpdate();
		}
	}	

	factory.commit();
}

DoArrayCurve();
